#pragma once
#include "Service.h"

/////////////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
/////////////////////////////////////////////////////////////////////////////////////
// Constants definitions use for indicator controls
#define kIndCBatteryChargeLvl			"battchg"
#define kIndCSignalQuality				"signal"
#define	kIndCServiceAvailability		"service"
#define kIndCSounderActivity			"sounder"
#define	kIndCMessageReceived			"message"
#define kIndCCallInProgress				"call"
#define kIndCTransmitVoice				"vox"
#define	kIndCRoamingInd					"roam"
#define	kIndCSmsStorageFull				"smsfull"
/////////////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CServiceCFG : public CService
{
private:
	int mMux;
public:
	CServiceCFG(void);
	CServiceCFG(CDllManager* iDllManager);
	virtual ~CServiceCFG(void);
	virtual Bool Dispatch(CCmd* iCmdP);
	virtual void OnConfigChange(int iConfigID);
	virtual void OnConfigChange(int iConfigID, int iConfigEvent);

	virtual void SendNotifStateChange();
	virtual void SendNotifFunChange();
	virtual void SendNotifSignalChange();
	virtual void SetMuxStatus(UInt8 iStatus);

	virtual Bool CLCK(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CMER(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CIND(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CVIB(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CALM(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CRSL(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CSCS(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGMI(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGMM(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGMR(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGSN(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CMEE(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool AT(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool E0V1(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool V(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool E(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CCLK(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CLVL(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CNUM(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool EC(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool ED(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool EF(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool Q(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool Z(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool L(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool M(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool X(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool S0(CCmd* iCmdP, Bool iSilentMode=0);	
	virtual Bool S7(CCmd* iCmdP, Bool iSilentMode=0);
	virtual int  CMUX(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CMUT(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CLAC(CCmd* iCmdP, Bool iSilentMode=0);
	
	virtual Bool CheckCMUXDependency(Bool iSilentMode);
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
